<?php

defined('BASEPATH') or exit('No direct script access allowed');

$baseCurrency = get_base_currency();

$aColumns = [
    db_prefix() . 'renewals.id',
    'subject',
    'proposal_to',
    'total',
    'date',
    'open_till',
    'followupdate',
    '(SELECT GROUP_CONCAT(name SEPARATOR ",") FROM ' . db_prefix() . 'taggables JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id WHERE rel_id = ' . db_prefix() . 'renewals.id and rel_type="renewal" ORDER by tag_order ASC) as tags',
    'datecreated',
    'status',
];
$sIndexColumn = 'id';
$sTable       = db_prefix() . 'renewals';

$where  = [];
$filter = [];

if ($this->ci->input->post('leads_related')) {
    array_push($filter, 'OR rel_type="lead"');
}
if ($this->ci->input->post('customers_related')) {
    array_push($filter, 'OR rel_type="customer"');
}
if ($this->ci->input->post('expired')) {
    array_push($filter, 'OR open_till IS NOT NULL AND open_till <"' . date('Y-m-d') . '" AND status NOT IN(2,3)');
}

$statuses  = $this->ci->renewals_model->get_statuses();
$statusIds = [];

foreach ($statuses as $status) {
    if ($this->ci->input->post('proposals_' . $status)) {
        array_push($statusIds, $status);
    }
}
if (count($statusIds) > 0) {
    array_push($filter, 'AND status IN (' . implode(', ', $statusIds) . ')');
}

// $agents    = $this->ci->renewals_model->get_sale_agents();
// $agentsIds = [];
// foreach ($agents as $agent) {
//     if ($this->ci->input->post('sale_agent_' . $agent['sale_agent'])) {
//         array_push($agentsIds, $agent['sale_agent']);
//     }
// }
// if (count($agentsIds) > 0) {
//     array_push($filter, 'AND assigned IN (' . implode(', ', $agentsIds) . ')');
// }

$years      = $this->ci->renewals_model->get_proposals_years();
$yearsArray = [];
foreach ($years as $year) {
    if ($this->ci->input->post('year_' . $year['year'])) {
        array_push($yearsArray, $year['year']);
    }
}
if (count($yearsArray) > 0) {
    array_push($filter, 'AND YEAR(date) IN (' . implode(', ', $yearsArray) . ')');
}

if (count($filter) > 0) {
    array_push($where, 'AND (' . prepare_dt_filter($filter) . ')');
}

if (!has_permission('proposals', '', 'view')) {
    array_push($where, 'AND ' . get_renewals_sql_where_staff(get_staff_user_id()));
}

$join          = [];
$custom_fields = get_table_custom_fields('renewal');

foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);

    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
    array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'renewals.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
    // array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'renewals.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
}

$aColumns = hooks()->apply_filters('renewals_table_sql_columns', $aColumns);

// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}

log_message("Error","................View Column.......................");
log_message("Error",print_r($aColumns,TRUE));
log_message("Error","................End View Column.......................");

log_message("Error","................View Index Column.......................");
log_message("Error",print_r($sIndexColumn,TRUE));
log_message("Error","................End View Index Column.......................");

log_message("Error","................View Table .......................");
log_message("Error",print_r($sTable,TRUE));
log_message("Error","................End View Table .......................");

log_message("Error","................View Join.......................");
log_message("Error",print_r($join,TRUE));
log_message("Error","................End View Join.......................");

log_message("Error","................View Where Condition.......................");
log_message("Error",print_r($where,TRUE));
log_message("Error","................End View  Where Condition.......................");

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'currency',
    'rel_id',
    'rel_type',
    'invoice_id',
    'hash',
]);

$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
$renewal_id=$aRow[db_prefix() . 'renewals.id'];




    $numberOutput = '<a href="' . admin_url('renewals/list_renewals/' . $aRow[db_prefix() . 'renewals.id']) . '" onclick="init_renewal(' . $aRow[db_prefix() . 'renewals.id'] . '); return false;">' . format_renewal_number($aRow[db_prefix() . 'renewals.id']) . '</a>';

    $numberOutput .= '<div class="row-options">';

    // $numberOutput .= '<a href="' . site_url('renewal/' . $aRow[db_prefix() . 'renewals.id'] . '/' . $aRow['hash']) . '" target="_blank">' . _l('view') . '</a>';
    if (has_permission('proposals', '', 'edit')) {
        $numberOutput .= ' | <a href="' . admin_url('renewals/renewal/' . $aRow[db_prefix() . 'renewals.id']) . '">' . _l('edit') . '</a>';
    }
    $numberOutput .= '</div>';
 
   
    
      
    $row[] = $numberOutput;

    $row[] = '<a href="' . admin_url('renewals/list_renewals/' . $aRow[db_prefix() . 'renewals.id']) . '" onclick="init_renewal(' . $aRow[db_prefix() . 'renewals.id'] . '); return false;">' . $aRow['subject'] . '</a>';

    if ($aRow['rel_type'] == 'lead') {
        $toOutput = '<a href="#" onclick="init_lead(' . $aRow['rel_id'] . ');return false;" target="_blank" data-toggle="tooltip" data-title="' . _l('lead') . '">' . $aRow['proposal_to'] . '</a>';
    } elseif ($aRow['rel_type'] == 'customer') {
        $toOutput = '<a href="' . admin_url('clients/client/' . $aRow['rel_id']) . '" target="_blank" data-toggle="tooltip" data-title="' . _l('client') . '">' . $aRow['proposal_to'] . '</a>';
    }

    $row[] = $toOutput;
    
  $row[] = ($aRow['followupdate'] != '' ? _dt($aRow['followupdate']) : '' ); ;
  
  $date= $aRow['followupdate'];

    $remind='';
     if($date!=""){
     $fdate = date_create($date);  
      $fdate2= date_format($fdate,"Y-m-d");
        $vdate= date_format($fdate,"d-m-Y h:i:s a");
        
       // $fdate = $lead->lead_last_contacted;
        $fdate= date_format($fdate,"Y-m-d H:i");
        $tdate = date("Y-m-d H:i");
        $tdate2 = date("Y-m-d");
       
        if(strtotime($fdate) > strtotime($tdate)){
        $remind.='<label class="label fstatus-ongoing">Ongoing</label>';
         
       
        }
       
        elseif(strtotime($fdate) < strtotime($tdate)){
             $remind.='<label class="label fstatus-overdue">Overdue</label>';
             
        }
       
        else{
              $remind.='<label class="label fstatus-duetoday">Due Now</label>';
              
        }
         
         if(strtotime($fdate2) == strtotime($tdate2)){
           $remind.='&nbsp;&nbsp;&nbsp;<label class="label label-duetoday">Today</label>';
      }
     }else{
               $remind.='-';
        }
    $row[] = $remind;
          
   

    $amount = app_format_money($aRow['total'], ($aRow['currency'] != 0 ? get_currency($aRow['currency']) : $baseCurrency));

    if ($aRow['invoice_id']) {
        $amount .= '<br /> <span class="hide"> - </span><span class="text-success">' . _l('estimate_invoiced') . '</span>';
    }

    $row[] = $amount;


    $row[] = _d($aRow['date']);

    $row[] = _d($aRow['open_till']);

    // $row[] = render_tags($aRow['tags']);

    // $row[] = _d($aRow['datecreated']);
    
        
     $date= $aRow['open_till'];
     if($date!=""){
         $edate = date_create($date);  
         $edate = date_format($edate,"d-m-Y H:i");  //Followup Date & time
         $fdate2 = date_format($edate,"d-m-Y");  //Followup Date & time
         
         $cdate= date("d-m-Y H:i"); // Current Date & Time
         $cdate2= date("d-m-H"); // Current Date & Time
         
        $bdate = date_create($date) ;
        date_sub($bdate, date_interval_create_from_date_string('60 days'));
        $bdate= date_format($bdate, 'd-m-Y H:i');  // Before 60 days
        $bdate2= date_format($bdate, 'd-m-Y');  // Before 60 days
         
         
         $status="";
       
         if(strtotime($edate) < strtotime($cdate)){
             $status.='<label class="label status-overdue">Overdue</label>';
         }
         else if(strtotime($edate2) == strtotime($cdate2)){
                  $status.='<label class="label status-duetoday">Today</label>';
         }
          else if(strtotime($edate2) >= strtotime($bdate2)){
                  $status.='<label class="label status_exp_soon">Exp.Soon</label>';
         }
         else{
                 $status.='<label class="label status-ongoing">Up Coming</label>';
         }
         
     }else{
               $status.='-';
        }
        
    $row[] = $status;
          
   

    // $row[] = format_renewal_status($aRow['status']);

    // Custom fields add values
    foreach ($customFieldsColumns as $customFieldColumn) {
        $row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
    }

    $row['DT_RowClass'] = 'has-row-options';

    $row = hooks()->apply_filters('renewals_table_row_data', $row, $aRow);

    $output['aaData'][] = $row;
}
