<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="city_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button group="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
                    <span class="edit-title"><?php echo _l('city_edit_heading'); ?></span>
                    <span class="add-title"><?php echo _l('city_add_heading'); ?></span>
                </h4>
            </div>
            <?php echo form_open('admin/clients/city',array('id'=>'city-modal')); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <?php echo render_input('name','city_name'); ?>
                        <?php echo form_hidden('id'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button group="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button group="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<script>
    window.addEventListener('load',function(){
        // alert(admin_url + "misc/city_name_exists");
    //   appValidateForm($('#city-modal'), {
    //     name: 'required'
        
    // }, manage_cities);
    
           appValidateForm($('#city-modal'), {
           name: {
               required: true,
               remote: {
                   url: admin_url + "misc/city_name_exists",
                   type: 'post',
                   data: {
                       name: function() {
                           return $('input[name="name"]').val();
                       },
                       id: function() {
                           return $('input[name="id"]').val();
                       }
                   }
               }
           }
       }, manage_cities);

    
    

       $('#city_modal').on('show.bs.modal', function(e) {
        var invoker = $(e.relatedTarget);
        var city_id = $(invoker).data('id');
        $('#city_modal .add-title').removeClass('hide');
        $('#city_modal .edit-title').addClass('hide');
        $('#city_modal input[name="id"]').val('');
        $('#city_modal input[name="name"]').val('');
        // is from the edit button
        if (typeof(city_id) !== 'undefined') {
            $('#city_modal input[name="id"]').val(city_id);
            $('#city_modal .add-title').addClass('hide');
            $('#city_modal .edit-title').removeClass('hide');
            $('#city_modal input[name="name"]').val($(invoker).parents('tr').find('td').eq(0).text());
        }
    });
   });
    function manage_cities(form) {
        var data = $(form).serialize();
        var url = form.action;
        $.post(url, data).done(function(response) {
            response = JSON.parse(response);
            if (response.success == true) {
                if($.fn.DataTable.isDataTable('.table-cities')){
                    $('.table-cities').DataTable().ajax.reload();
                }
                if($('body').hasClass('dynamic-create-groups') && typeof(response.id) != 'undefined') {
                    var groups = $('select[name="groups_in[]"]');
                    groups.prepend('<option value="'+response.id+'">'+response.name+'</option>');
                    groups.selectpicker('refresh');
                }
                alert_float('success', response.message);
            }
            $('#city_modal').modal('hide');
        });
        return false;
    }

</script>
