<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Renewals_model extends App_Model
{
    private $statuses;

    private $copy = false;
    
    const STATUS_ONGOING = 1;

    const STATUS_EXPIRING_SOON = 2;

    const STATUS_EXPIRED = 3;

    const STATUS_PENDING = 4;

    public function __construct()
    {
        parent::__construct();
        // $this->statuses = hooks()->apply_filters('before_set_renewal_statuses', [
        //     6,
        //     4,
        //     1,
        //     5,
        //     2,
        //     3,
        // ]); 
        
        $this->statuses = [
        self::STATUS_ONGOING,
        self::STATUS_EXPIRING_SOON,
        self::STATUS_EXPIRED,
        self::STATUS_PENDING
        ];
    }

    public function get_statuses()
    {
        return $this->statuses;
    }

    public function get_sale_agents()
    {
        // return $this->db->query('SELECT DISTINCT(assigned) as sale_agent FROM ' . db_prefix() . 'renewals WHERE assigned != 0')->result_array();
        $sales_agents= $this->db->query('SELECT DISTINCT(staff_id) as sale_agent FROM ' . db_prefix() . 'renewal_members WHERE staff_id != 0')->result_array();
    //     log_message("Error","..........Get Sales Agents..........");
    //   log_message( "Error",print_r($sales_agents, TRUE) );
    //   log_message("Error",".......... End Get Sales Agents..........");
         return  $sales_agents;
    }

    public function get_proposals_years()
    {
        return $this->db->query('SELECT DISTINCT(YEAR(date)) as year FROM ' . db_prefix() . 'renewals')->result_array();
    }

    public function do_kanban_query($status, $search = '', $page = 1, $sort = [], $count = false)
    {
        $default_pipeline_order      = get_option('default_proposals_pipeline_sort');
        $default_pipeline_order_type = get_option('default_proposals_pipeline_sort_type');
        $limit                       = get_option('proposals_pipeline_limit');

        $has_permission_view                 = has_permission('proposals', '', 'view');
        $has_permission_view_own             = has_permission('proposals', '', 'view_own');
        $allow_staff_view_proposals_assigned = get_option('allow_staff_view_proposals_assigned');
        $staffId                             = get_staff_user_id();

        $noPermissionQuery = get_proposals_sql_where_staff(get_staff_user_id());

        $this->db->select('id,invoice_id,estimate_id,subject,rel_type,rel_id,total,date,open_till,currency,proposal_to,status');
        $this->db->from(db_prefix() . 'renewals');
        $this->db->where('status', $status);
        if (!$has_permission_view) {
            $this->db->where($noPermissionQuery);
        }
        if ($search != '') {
            if (!startsWith($search, '#')) {
                $this->db->where('(
                phone LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                zip LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                content LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                state LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                city LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                email LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                address LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                proposal_to LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                total LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\'
                OR
                subject LIKE "%' . $this->db->escape_like_str($search) . '%" ESCAPE \'!\')');
            } else {
                $this->db->where(db_prefix() . 'renewals.id IN
                (SELECT rel_id FROM ' . db_prefix() . 'taggables WHERE tag_id IN
                (SELECT id FROM ' . db_prefix() . 'tags WHERE name="' . $this->db->escape_str(strafter($search, '#')) . '")
                AND ' . db_prefix() . 'taggables.rel_type=\'proposal\' GROUP BY rel_id HAVING COUNT(tag_id) = 1)
                ');
            }
        }

        if (isset($sort['sort_by']) && $sort['sort_by'] && isset($sort['sort']) && $sort['sort']) {
            $this->db->order_by($sort['sort_by'], $sort['sort']);
        } else {
            $this->db->order_by($default_pipeline_order, $default_pipeline_order_type);
        }

        if ($count == false) {
            if ($page > 1) {
                $page--;
                $position = ($page * $limit);
                $this->db->limit($limit, $position);
            } else {
                $this->db->limit($limit);
            }
        }

        if ($count == false) {
            return $this->db->get()->result_array();
        }

        return $this->db->count_all_results();
    }

    /**
     * Inserting new proposal function
     * @param mixed $data $_POST data
     */
    public function add($data)
    {
        $data['allow_comments'] = isset($data['allow_comments']) ? 1 : 0;

        $save_and_send = isset($data['save_and_send']);

        $tags = isset($data['tags']) ? $data['tags'] : '';

        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            unset($data['custom_fields']);
        }

        $estimateRequestID = false;
        if (isset($data['estimate_request_id'])) {
            $estimateRequestID = $data['estimate_request_id'];
            unset($data['estimate_request_id']);
        }
        
         if (isset($data['renewal_users'])) {
            $assigned_users = $data['renewal_users'];
            unset($data['renewal_users']);
        }

        $data['address'] = trim($data['address']);
        $data['address'] = nl2br($data['address']);

        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['addedfrom']   = get_staff_user_id();
        $data['hash']        = app_generate_hash();

        if (empty($data['rel_type'])) {
            unset($data['rel_type']);
            unset($data['rel_id']);
        } else {
            if (empty($data['rel_id'])) {
                unset($data['rel_type']);
                unset($data['rel_id']);
            }
        }

        $domain_items = [];
        if (isset($data['domain_newitems'])) {
            $domain_items = $data['domain_newitems'];
            unset($data['domain_newitems']);
        }
        $server_items = [];
        if (isset($data['server_newitems'])) {
            $server_items = $data['server_newitems'];
            unset($data['server_newitems']);
        }
        $webmail_items = [];
        if (isset($data['webmail_newitems'])) {
            $webmail_items = $data['webmail_newitems'];
            unset($data['webmail_newitems']);
        }

        if ($this->copy == false) {
            $data['content'] = '{proposal_items}';
        }

        $hook = hooks()->apply_filters('before_create_proposal', [
            'data'  => $data,
            'domain_items' => $domain_items,
            'server_items' => $server_items,
            'webmail_items' => $webmail_items,
        ]);

        $data  = $hook['data'];
        $domain_items = $hook['domain_items'];
        $server_items = $hook['server_items'];
        $webmail_items = $hook['webmail_items'];

        $this->db->insert(db_prefix() . 'renewals', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            
            if (isset($assigned_users)) {
                $_pm['renewal_members'] = $assigned_users;
                $this->add_edit_members($_pm, $insert_id);
                log_message("Error","Assigned User List");
                error_log( print_r($_pm, TRUE) );
            }
            
               

            
            if ($estimateRequestID !== false && $estimateRequestID != '') {
                $this->load->model('estimate_request_model');
                $completedStatus = $this->estimate_request_model->get_status_by_flag('completed');
                $this->estimate_request_model->update_request_status([
                    'requestid' => $estimateRequestID,
                    'status' => $completedStatus->id,
                ]);
            }

            if (isset($custom_fields)) {
                handle_custom_fields_post($insert_id, $custom_fields);
            }

            handle_tags_save($tags, $insert_id, 'renewal');

            foreach ($domain_items as $key => $domain_item) {
                if ($itemid = add_new_sales_item_post($domain_item, $insert_id, 'domain_renewal')) {
                    _maybe_insert_post_item_tax($itemid, $domain_item, $insert_id, 'domain_renewal');
                }
            }
            foreach ($server_items as $key => $server_item) {
                if ($itemid = add_new_server_item_post($server_item, $insert_id, 'server_renewal')) {
                    _maybe_insert_post_item_tax($itemid, $server_item, $insert_id, 'server_renewal');
                }
            }  
            foreach ($webmail_items as $key => $webmail_item) {
                if ($itemid = add_new_sales_item_post($webmail_item, $insert_id, 'webmail_renewal')) {
                    _maybe_insert_post_item_tax($itemid, $webmail_item, $insert_id, 'webmail_renewal');
                }
            }

            $proposal = $this->get($insert_id);
            if ($proposal->assigned != 0) {
                if ($proposal->assigned != get_staff_user_id()) {
                    $notified = add_notification([
                        'description'     => 'not_proposal_assigned_to_you',
                        'touserid'        => $proposal->assigned,
                        'fromuserid'      => get_staff_user_id(),
                        'link'            => 'renewals/list_renewals/' . $insert_id,
                        'additional_data' => serialize([
                            $proposal->subject,
                        ]),
                    ]);
                    if ($notified) {
                        pusher_trigger_notification([$proposal->assigned]);
                    }
                }
            }

            if ($data['rel_type'] == 'lead') {
                $this->load->model('leads_model');
                $this->leads_model->log_lead_activity($data['rel_id'], 'not_lead_activity_created_proposal', false, serialize([
                    '<a href="' . admin_url('renewals/list_renewals/' . $insert_id) . '" target="_blank">' . $data['subject'] . '</a>',
                ]));
            }

            update_sales_total_tax_column($insert_id, 'renewal', db_prefix() . 'renewals');

            log_activity('New Renewal Created [ID: ' . $insert_id . ']');

            if ($save_and_send === true) {
                $this->send_proposal_to_email($insert_id);
            }

            hooks()->do_action('proposal_created', $insert_id);

            return $insert_id;
        }

        return false;
    }
    
    
    
    public function add_edit_members($data, $id)
    {
        $affectedRows = 0;
        if (isset($data['renewal_members'])) {
            $renewal_members = $data['renewal_members'];
        }

        $new_renewal_members_to_receive_email = [];
        // $this->db->select('name,clientid');
        $this->db->select('subject');
        $this->db->where('id', $id);
        $renewal      = $this->db->get(db_prefix() . 'renewals')->row();
        $renewal_subject = $renewal->subject;
        // $client_id    = $renewal->clientid;

        $renewal_members_in = $this->get_renewal_members($id);
        if (sizeof($renewal_members_in) > 0) {
            foreach ($renewal_members_in as $renewal_member) {
                if (isset($renewal_members)) {
                    if (!in_array($renewal_member['staff_id'], $renewal_members)) {
                        $this->db->where('renewal_id', $id);
                        $this->db->where('staff_id', $renewal_member['staff_id']);
                        $this->db->delete(db_prefix() . 'renewal_members');
                        // if ($this->db->affected_rows() > 0) {
                        //     $this->db->where('staff_id', $renewal_member['staff_id']);
                        //     $this->db->where('renewal_id', $id);
                        //     $this->db->delete(db_prefix() . 'pinned_projects');

                        //     $this->log_activity($id, 'project_activity_removed_team_member', get_staff_full_name($project_member['staff_id']));
                        //     $affectedRows++;
                        // }
                    }
                } else {
                    $this->db->where('renewal_id', $id);
                    $this->db->delete(db_prefix() . 'renewal_members');
                    if ($this->db->affected_rows() > 0) {
                        $affectedRows++;
                    }
                }
            }
            if (isset($renewal_members)) {
                $notifiedUsers = [];
                foreach ($renewal_members as $staff_id) {
                    $this->db->where('renewal_id', $id);
                    $this->db->where('staff_id', $staff_id);
                    $_exists = $this->db->get(db_prefix() . 'renewal_members')->row();
                    if (!$_exists) {
                        if (empty($staff_id)) {
                            continue;
                        }
                        $this->db->insert(db_prefix() . 'renewal_members', [
                            'renewal_id' => $id,
                            'staff_id'   => $staff_id,
                        ]);
                        if ($this->db->affected_rows() > 0) {
                            if ($staff_id != get_staff_user_id()) {
                                $notified = add_notification([
                                    'fromuserid'      => get_staff_user_id(),
                                    'description'     => 'not_staff_added_as_renewal_member',
                                    'link'            => 'renewals/view/' . $id,
                                    'touserid'        => $staff_id,
                                    'additional_data' => serialize([
                                        $renewal_subject,
                                    ]),
                                ]);
                                array_push($new_renewal_members_to_receive_email, $staff_id);
                                if ($notified) {
                                    array_push($notifiedUsers, $staff_id);
                                }
                            }


                            // $this->log_activity($id, 'project_activity_added_team_member', get_staff_full_name($staff_id));
                            $affectedRows++;
                        }
                    }
                }
                pusher_trigger_notification($notifiedUsers);
            }
        } else {
            if (isset($renewal_members)) {
                $notifiedUsers = [];
                foreach ($renewal_members as $staff_id) {
                    if (empty($staff_id)) {
                        continue;
                    }
                    $this->db->insert(db_prefix() . 'renewal_members', [
                        'renewal_id' => $id,
                        'staff_id'   => $staff_id,
                    ]);
                    if ($this->db->affected_rows() > 0) {
                        if ($staff_id != get_staff_user_id()) {
                            $notified = add_notification([
                                'fromuserid'      => get_staff_user_id(),
                                'description'     => 'not_staff_added_as_renewal_member',
                                'link'            => 'renewals/view/' . $id,
                                'touserid'        => $staff_id,
                                'additional_data' => serialize([
                                    $renewal_subject,
                                ]),
                            ]);
                            array_push($new_renewal_members_to_receive_email, $staff_id);
                            if ($notifiedUsers) {
                                array_push($notifiedUsers, $staff_id);
                            }
                        }
                        // $this->log_activity($id, 'project_activity_added_team_member', get_staff_full_name($staff_id));
                        $affectedRows++;
                    }
                }
                pusher_trigger_notification($notifiedUsers);
            }
        }

        if (count($new_renewal_members_to_receive_email) > 0) {
            $all_members = $this->get_renewal_members($id);
            foreach ($all_members as $data) {
                if (in_array($data['staff_id'], $new_renewal_members_to_receive_email)) {
                    send_mail_template('project_staff_added_as_member', $data, $id, $client_id);
                }
            }
        }
        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }
    
    
    // public function log_activity($renewal_id, $description_key, $additional_data = '', $visible_to_customer = 1)
    // {
    //     if (!DEFINED('CRON')) {
    //         if (is_client_logged_in()) {
    //             $data['contact_id'] = get_contact_user_id();
    //             $data['staff_id']   = 0;
    //             $data['fullname']   = get_contact_full_name(get_contact_user_id());
    //         } elseif (is_staff_logged_in()) {
    //             $data['contact_id'] = 0;
    //             $data['staff_id']   = get_staff_user_id();
    //             $data['fullname']   = get_staff_full_name(get_staff_user_id());
    //         }
    //     } else {
    //         $data['contact_id'] = 0;
    //         $data['staff_id']   = 0;
    //         $data['fullname']   = '[CRON]';
    //     }
    //     $data['description_key']     = $description_key;
    //     $data['additional_data']     = $additional_data;
    //     $data['visible_to_customer'] = $visible_to_customer;
    //     $data['project_id']          = $project_id;
    //     $data['dateadded']           = date('Y-m-d H:i:s');

    //     $data = hooks()->apply_filters('before_log_project_activity', $data);

    //     $this->db->insert(db_prefix() . 'project_activity', $data);
    // }


     public function get_renewal_members($id)
    {
        $this->db->select('email,renewal_id,staff_id');
        $this->db->join(db_prefix() . 'staff', db_prefix() . 'staff.staffid=' . db_prefix() . 'renewal_members.staff_id');
        $this->db->where('renewal_id', $id);

        return $this->db->get(db_prefix() . 'renewal_members')->result_array();
    }

    /**
     * Update proposal
     * @param  mixed $data $_POST data
     * @param  mixed $id   proposal id
     * @return boolean
     */
    public function update($data, $id)
    {
        $affectedRows = 0;

        $data['allow_comments'] = isset($data['allow_comments']) ? 1 : 0;

        $current_proposal = $this->get($id);

        $save_and_send = isset($data['save_and_send']);

        if (empty($data['rel_type'])) {
            $data['rel_id']   = null;
            $data['rel_type'] = '';
        } else {
            if (empty($data['rel_id'])) {
                $data['rel_id']   = null;
                $data['rel_type'] = '';
            }
        }
         if (isset($data['renewal_users'])) {
            $assigned_users = $data['renewal_users'];
            unset($data['renewal_users']);
        }

        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            if (handle_custom_fields_post($id, $custom_fields)) {
                $affectedRows++;
            }
            unset($data['custom_fields']);
        }
          
      
        $domain_items = [];
        if (isset($data['domain_items'])) {
            $domain_items = $data['domain_items'];
            unset($data['domain_items']);
        }
        $server_items = [];
        if (isset($data['server_items'])) {
            $server_items = $data['server_items'];
            unset($data['server_items']);
        }
        $webmail_items = [];
        if (isset($data['webmail_items'])) {
            $webmail_items = $data['webmail_items'];
            unset($data['webmail_items']);
        }

        $domain_newitems = [];
        if (isset($data['domain_newitems'])) {
            $domain_newitems = $data['domain_newitems'];
            unset($data['domain_newitems']);
        } 
        $server_newitems = [];
        if (isset($data['server_newitems'])) {
            $server_newitems = $data['server_newitems'];
            unset($data['server_newitems']);
        }
        $webmail_newitems = [];
        if (isset($data['webmail_newitems'])) {
            $webmail_newitems = $data['webmail_newitems'];
            unset($data['webmail_newitems']);
        }

        if (isset($data['tags'])) {
            if (handle_tags_save($data['tags'], $id, 'renewal')) {
                $affectedRows++;
            }
        }

        $data['address'] = trim($data['address']);
        $data['address'] = nl2br($data['address']);

        $hook = hooks()->apply_filters('before_proposal_updated', [
            'data'          => $data,
            'domain_items'         => $domain_items,
            'domain_newitems'      => $domain_newitems,
            'domain_removed_items' => isset($data['domain_removed_items']) ? $data['domain_removed_items'] : [],
            
            'server_items'         => $server_items,
            'server_newitems'      => $server_newitems,
            'server_removed_items' => isset($data['server_removed_items']) ? $data['server_removed_items'] : [],
            
            'webmail_items'         => $webmail_items,
            'webmail_newitems'      => $webmail_newitems,
            'webmail_removed_items' => isset($data['webmail_removed_items']) ? $data['webmail_removed_items'] : [],
        ], $id);
        
        //  $hook = hooks()->apply_filters('before_proposal_updated', [
        //     'data'          => $data,
        //     'server_items'         => $server_items,
        //     'server_newitems'      => $sever_newitems,
        //     'removed_items' => isset($data['removed_items']) ? $data['removed_items'] : [],
        // ], $id);


        $data                  = $hook['data'];
        $data['domain_removed_items'] = $hook['domain_removed_items'];
        $data['server_removed_items'] = $hook['server_removed_items'];
        $data['webmail_removed_items'] = $hook['webmail_removed_items'];
        
        $domain_newitems              = $hook['domain_newitems'];
        $domain_items                 = $hook['domain_items']; 
        
        $server_newitems              = $hook['server_newitems'];
        $server_items                 = $hook['server_items'];
 
        $webmail_newitems              = $hook['webmail_newitems'];
        $webmail_items                 = $hook['webmail_items'];

        // Delete items checked to be removed from database
        foreach ($data['domain_removed_items'] as $remove_item_id) {
            if (handle_removed_sales_item_post($remove_item_id, 'domain_renewal')) {
                $affectedRows++;
            }
        } 
        foreach ($data['server_removed_items'] as $remove_item_id) {
            if (handle_removed_sales_item_post($remove_item_id, 'server_renewal')) {
                $affectedRows++;
            }
        } 
        foreach ($data['webmail_removed_items'] as $remove_item_id) {
            if (handle_removed_sales_item_post($remove_item_id, 'webmail_renewal')) {
                $affectedRows++;
            }
        }

        unset($data['domain_removed_items']);
        unset($data['server_removed_items']);
        unset($data['webmail_removed_items']);

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'renewals', $data);
        

         if (isset($assigned_users)) {
                $_pm['renewal_members'] = $assigned_users;
                $this->add_edit_members($_pm, $id);
                log_message("Error","Assigned User List");
                error_log( print_r($_pm, TRUE) );
            }


        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            $proposal_now = $this->get($id);
            if ($current_proposal->assigned != $proposal_now->assigned) {
                if ($proposal_now->assigned != get_staff_user_id()) {
                    $notified = add_notification([
                        'description'     => 'not_proposal_assigned_to_you',
                        'touserid'        => $proposal_now->assigned,
                        'fromuserid'      => get_staff_user_id(),
                        'link'            => 'renewals/list_renewals/' . $id,
                        'additional_data' => serialize([
                            $proposal_now->subject,
                        ]),
                    ]);
                    if ($notified) {
                        pusher_trigger_notification([$proposal_now->assigned]);
                    }
                }
            }
        }

        foreach ($domain_items as $key => $domain_item) {
            if (update_sales_item_post($domain_item['itemid'], $domain_item)) {
                $affectedRows++;
            }

            if (isset($domain_item['custom_fields'])) {
                if (handle_custom_fields_post($domain_item['itemid'], $domain_item['custom_fields'])) {
                    $affectedRows++;
                }
            }

            if (!isset($domain_item['taxname']) || (isset($domain_item['taxname']) && count($domain_item['taxname']) == 0)) {
                if (delete_taxes_from_item($domain_item['itemid'], 'renewal')) {
                    $affectedRows++;
                }
            } else {
                $item_taxes        = get_proposal_item_taxes($domain_item['itemid']);
                $_item_taxes_names = [];
                foreach ($item_taxes as $_item_tax) {
                    array_push($_item_taxes_names, $_item_tax['taxname']);
                }
                $i = 0;
                foreach ($_item_taxes_names as $_item_tax) {
                    if (!in_array($_item_tax, $domain_item['taxname'])) {
                        $this->db->where('id', $item_taxes[$i]['id'])
                        ->delete(db_prefix() . 'item_tax');
                        if ($this->db->affected_rows() > 0) {
                            $affectedRows++;
                        }
                    }
                    $i++;
                }
                if (_maybe_insert_post_item_tax($domain_item['itemid'], $domain_item, $id, 'domain_renewal')) {
                    $affectedRows++;
                }
            }
        }
        
            error_log( print_r($server_items, TRUE) );
        foreach ($server_items as $key => $server_item) {
            
            if (update_server_item_post($server_item['itemid'], $server_item)) {
                $affectedRows++;
            }

            if (isset($server_item['custom_fields'])) {
                if (handle_custom_fields_post($server_item['itemid'], $server_item['custom_fields'])) {
                    $affectedRows++;
                }
            }

            if (!isset($server_item['taxname']) || (isset($server_item['taxname']) && count($server_item['taxname']) == 0)) {
                if (delete_taxes_from_item($server_item['itemid'], 'renewal')) {
                    $affectedRows++;
                }
            } else {
                $item_taxes        = get_proposal_item_taxes($server_item['itemid']);
                $_item_taxes_names = [];
                foreach ($item_taxes as $_item_tax) {
                    array_push($_item_taxes_names, $_item_tax['taxname']);
                }
                $i = 0;
                foreach ($_item_taxes_names as $_item_tax) {
                    if (!in_array($_item_tax, $server_item['taxname'])) {
                        $this->db->where('id', $item_taxes[$i]['id'])
                        ->delete(db_prefix() . 'item_tax');
                        if ($this->db->affected_rows() > 0) {
                            $affectedRows++;
                        }
                    }
                    $i++;
                }
                if (_maybe_insert_post_item_tax($server_item['itemid'], $server_item, $id, 'server_renewal')) {
                    $affectedRows++;
                }
            }
        }
        foreach ($webmail_items as $key => $webmail_item) {
            if (update_sales_item_post($webmail_item['itemid'], $webmail_item)) {
                $affectedRows++;
            }

            if (isset($webmail_item['custom_fields'])) {
                if (handle_custom_fields_post($webmail_item['itemid'], $webmail_item['custom_fields'])) {
                    $affectedRows++;
                }
            }

            if (!isset($webmail_item['taxname']) || (isset($webmail_item['taxname']) && count($webmail_item['taxname']) == 0)) {
                if (delete_taxes_from_item($webmail_item['itemid'], 'renewal')) {
                    $affectedRows++;
                }
            } else {
                $item_taxes        = get_proposal_item_taxes($webmail_item['itemid']);
                $_item_taxes_names = [];
                foreach ($item_taxes as $_item_tax) {
                    array_push($_item_taxes_names, $_item_tax['taxname']);
                }
                $i = 0;
                foreach ($_item_taxes_names as $_item_tax) {
                    if (!in_array($_item_tax, $webmail_item['taxname'])) {
                        $this->db->where('id', $item_taxes[$i]['id'])
                        ->delete(db_prefix() . 'item_tax');
                        if ($this->db->affected_rows() > 0) {
                            $affectedRows++;
                        }
                    }
                    $i++;
                }
                if (_maybe_insert_post_item_tax($webmail_item['itemid'], $server_item, $id, 'webmail_renewal')) {
                    $affectedRows++;
                }
            }
        }
        // foreach ($items as $key => $item) {
        //     if (update_sales_item_post($item['itemid'], $item)) {
        //         $affectedRows++;
        //     }

        //     if (isset($item['custom_fields'])) {
        //         if (handle_custom_fields_post($item['itemid'], $item['custom_fields'])) {
        //             $affectedRows++;
        //         }
        //     }

        //     if (!isset($item['taxname']) || (isset($item['taxname']) && count($item['taxname']) == 0)) {
        //         if (delete_taxes_from_item($item['itemid'], 'renewal')) {
        //             $affectedRows++;
        //         }
        //     } else {
        //         $item_taxes        = get_proposal_item_taxes($item['itemid']);
        //         $_item_taxes_names = [];
        //         foreach ($item_taxes as $_item_tax) {
        //             array_push($_item_taxes_names, $_item_tax['taxname']);
        //         }
        //         $i = 0;
        //         foreach ($_item_taxes_names as $_item_tax) {
        //             if (!in_array($_item_tax, $item['taxname'])) {
        //                 $this->db->where('id', $item_taxes[$i]['id'])
        //                 ->delete(db_prefix() . 'item_tax');
        //                 if ($this->db->affected_rows() > 0) {
        //                     $affectedRows++;
        //                 }
        //             }
        //             $i++;
        //         }
        //         if (_maybe_insert_post_item_tax($item['itemid'], $item, $id, 'renewal')) {
        //             $affectedRows++;
        //         }
        //     }
        // }

        foreach ($domain_newitems as $key => $domain_item) {
            if ($new_item_added = add_new_sales_item_post($domain_item, $id, 'domain_renewal')) {
                _maybe_insert_post_item_tax($new_item_added, $domain_item, $id, 'domain_renewal');
                $affectedRows++;
            }
        }
        foreach ($server_newitems as $key => $server_item) {
            if ($new_item_added = add_new_server_item_post($server_item, $id, 'server_renewal')) {
                _maybe_insert_post_item_tax($new_item_added, $server_item, $id, 'server_renewal');
                $affectedRows++;
            }
        } 
        foreach ($webmail_newitems as $key => $webmail_item) {
            if ($new_item_added = add_new_sales_item_post($webmail_item, $id, 'webmail_renewal')) {
                _maybe_insert_post_item_tax($new_item_added, $webmail_item, $id, 'webmail_renewal');
                $affectedRows++;
            }
        }
        // foreach ($newitems as $key => $item) {
        //     if ($new_item_added = add_new_sales_item_post($item, $id, 'webmail')) {
        //         _maybe_insert_post_item_tax($new_item_added, $item, $id, 'webmail');
        //         $affectedRows++;
        //     }
        // }
        
        if ($affectedRows > 0) {
            update_sales_total_tax_column($id, 'renewal', db_prefix() . 'renewals');
            log_activity('Renewal Updated [ID:' . $id . ']');
        }
           
        if ($save_and_send === true) {
            $this->send_proposal_to_email($id);
        }
        

        if ($affectedRows > 0) {
            hooks()->do_action('after_proposal_updated', $id);

            return true;
        }

        return false;
    }

    /**
     * Get renewals
     * @param  mixed $id proposal id OPTIONAL
     * @return mixed
     */
    public function get($id = '', $where = [], $for_editor = false)
    {
        // log_message("error","Renewals => Get Step 1");
        // log_message("error","Where =>");
        // log_message("error",print_r($where,true));
        $this->db->where($where);
        // log_message("error","Renewals => Get Step 2");

        if (is_client_logged_in()) {
            $this->db->where('status !=', 0);
            // log_message("error","Renewals => Get Step 3");
        }

        $this->db->select('*,' . db_prefix() . 'currencies.id as currencyid, ' . db_prefix() . 'renewals.id as id, ' . db_prefix() . 'currencies.name as currency_name');
        // log_message("error","Renewals => Get Step 4");
        $this->db->from(db_prefix() . 'renewals');
        // log_message("error","Renewals => Get Step 5");
        $this->db->join(db_prefix() . 'currencies', db_prefix() . 'currencies.id = ' . db_prefix() . 'renewals.currency', 'left');
        // log_message("error","Renewals => Get Step 6");

        if (is_numeric($id)) {
            // log_message("error","Renewals => Get Step 7");
            $this->db->where(db_prefix() . 'renewals.id', $id);
            // log_message("error","Renewals => Get Step 8");
            $proposal = $this->db->get()->row();
            if ($proposal) {
                $proposal->attachments                           = $this->get_attachments($id);
                $proposal->domain_items                                 = get_items_by_type('domain_renewal', $id);
                $proposal->server_items                                 = get_items_by_type('server_renewal', $id);
                $proposal->webmail_items                                 = get_items_by_type('webmail_renewal', $id);
                $proposal->visible_attachments_to_customer_found = false;
                foreach ($proposal->attachments as $attachment) {
                    if ($attachment['visible_to_customer'] == 1) {
                        $proposal->visible_attachments_to_customer_found = true;

                        break;
                    }
                }
                if ($for_editor == false) {
                    $proposal = parse_proposal_content_merge_fields($proposal);
                }
            }

            return $proposal;
        }

        return $this->db->get()->result_array();
    }

    public function clear_signature($id)
    {
        $this->db->select('signature');
        $this->db->where('id', $id);
        $proposal = $this->db->get(db_prefix() . 'renewals')->row();

        if ($proposal) {
            $this->db->where('id', $id);
            $this->db->update(db_prefix() . 'renewals', ['signature' => null]);

            if (!empty($proposal->signature)) {
                unlink(get_upload_path_by_type('renewal') . $id . '/' . $proposal->signature);
            }

            return true;
        }

        return false;
    }

    public function update_pipeline($data)
    {
        $this->mark_action_status($data['status'], $data['proposalid']);
        foreach ($data['order'] as $order_data) {
            $this->db->where('id', $order_data[0]);
            $this->db->update(db_prefix() . 'renewals', [
                'pipeline_order' => $order_data[1],
            ]);
        }
    }

    public function get_attachments($proposal_id, $id = '')
    {
        // If is passed id get return only 1 attachment
        if (is_numeric($id)) {
            $this->db->where('id', $id);
        } else {
            $this->db->where('rel_id', $proposal_id);
        }
        $this->db->where('rel_type', 'renewal');
        $result = $this->db->get(db_prefix() . 'files');
        if (is_numeric($id)) {
            return $result->row();
        }

        return $result->result_array();
    }

    /**
     *  Delete proposal attachment
     * @param   mixed $id  attachmentid
     * @return  boolean
     */
    public function delete_attachment($id)
    {
        $attachment = $this->get_attachments('', $id);
        $deleted    = false;
        if ($attachment) {
            if (empty($attachment->external)) {
                unlink(get_upload_path_by_type('renewal') . $attachment->rel_id . '/' . $attachment->file_name);
            }
            $this->db->where('id', $attachment->id);
            $this->db->delete(db_prefix() . 'files');
            if ($this->db->affected_rows() > 0) {
                $deleted = true;
                log_activity('Renewal Attachment Deleted [ID: ' . $attachment->rel_id . ']');
            }
            if (is_dir(get_upload_path_by_type('renewal') . $attachment->rel_id)) {
                // Check if no attachments left, so we can delete the folder also
                $other_attachments = list_files(get_upload_path_by_type('renewal') . $attachment->rel_id);
                if (count($other_attachments) == 0) {
                    // okey only index.html so we can delete the folder also
                    delete_dir(get_upload_path_by_type('renewal') . $attachment->rel_id);
                }
            }
        }

        return $deleted;
    }

    /**
     * Add proposal comment
     * @param mixed  $data   $_POST comment data
     * @param boolean $client is request coming from the client side
     */
    public function add_comment($data, $client = false)
    {
        error_log( print_r($data, TRUE) );
        // error_message(print_r($data,TRUE));
        if (is_staff_logged_in()) {
            $client = false;
        }
        if (isset($data['action'])) {
          
            unset($data['action']);
        }
        $data['dateadded'] = date('Y-m-d H:i:s');
        if ($client == false) {
            $data['staffid'] = get_staff_user_id();
        }
        // Set Followup date
        //  if($data['contacted_indicator'] == 'yes') 
        //  {
        //     $data['followupdate'] = to_sql_date($data['set_reminder_date'], true);
        //   unset($data['set_reminder_date']);
        //  }
        //   unset($data['contacted_indicator']);   
        //   End       
        $data['content'] = nl2br($data['content']);
        if(isset($data['followup_date'])){
            $data['followupdate'] = to_sql_date($data['followup_date'], true);
            unset($data['followup_date']);
             $datareminder['rel_type']         = 'renewal';
                    $datareminder['rel_id']         = $data['proposalid'];
                    log_message("Error","Renewal_ID=>".$data['proposalid']);
                    $datareminder['staff']         =get_staff_user_id();
                    $datareminder['date']         = $data['followupdate'];
                    // $contacted_date =  date('Y-m-d H:i:s');
                    $datareminder['notify_by_email'] = "yes";
                    // $followup_date =   $this->input->post('date');
                    $datareminder['description'] = $data['content'];
                    $success = $this->misc_model->add_reminder($datareminder, $this->get($data['proposalid']));
         
        }
        $this->db->where('id', $data['proposalid']);
        $this->db->update(db_prefix() . 'renewals', [
            'followupdate' => $data['followupdate'],
        ]);
        log_message("Error","Followup Date =>".$data['followupdate']);
        $this->db->insert(db_prefix() . 'renewal_comments', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            $proposal = $this->get($data['proposalid']);

            // No notifications client when proposal is with draft status
            if ($proposal->status == '6' && $client == false) {
                return true;
            }

            if ($client == true) {
                // Get creator and assigned
                $this->db->select('staffid,email,phonenumber');
                $this->db->where('staffid', $proposal->addedfrom);
                $this->db->or_where('staffid', $proposal->assigned);
                $staff_proposal = $this->db->get(db_prefix() . 'staff')->result_array();
                $notifiedUsers  = [];
                foreach ($staff_proposal as $member) {
                    $notified = add_notification([
                        'description'     => 'not_proposal_comment_from_client',
                        'touserid'        => $member['staffid'],
                        'fromcompany'     => 1,
                        'fromuserid'      => 0,
                        'link'            => 'renewals/list_renewals/' . $data['proposalid'],
                        'additional_data' => serialize([
                            $proposal->subject,
                        ]),
                    ]);

                    if ($notified) {
                        array_push($notifiedUsers, $member['staffid']);
                    }

                    $template     = mail_template('proposal_comment_to_staff', $proposal->id, $member['email']);
                    $merge_fields = $template->get_merge_fields();
                    $template->send();
                    // Send email/sms to admin that client commented
                    $this->app_sms->trigger(SMS_TRIGGER_PROPOSAL_NEW_COMMENT_TO_STAFF, $member['phonenumber'], $merge_fields);
                }
                pusher_trigger_notification($notifiedUsers);
            } else {
                // Send email/sms to client that admin commented
                $template     = mail_template('proposal_comment_to_customer', $proposal);
                $merge_fields = $template->get_merge_fields();
                $template->send();
                $this->app_sms->trigger(SMS_TRIGGER_PROPOSAL_NEW_COMMENT_TO_CUSTOMER, $proposal->phone, $merge_fields);
            }

            return true;
        }

        return false;
    }

    public function edit_comment($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'renewal_comments', [
            'content' => nl2br($data['content']),
        ]);
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }

    /**
     * Get proposal comments
     * @param  mixed $id proposal id
     * @return array
     */
    public function get_comments($id)
    {
        $this->db->where('proposalid', $id);
        $this->db->order_by('dateadded', 'ASC');

        return $this->db->get(db_prefix() . 'renewal_comments')->result_array();
    }

    /**
     * Get proposal single comment
     * @param  mixed $id  comment id
     * @return object
     */
    public function get_comment($id)
    {
        $this->db->where('id', $id);

        return $this->db->get(db_prefix() . 'renewal_comments')->row();
    }

    /**
     * Remove proposal comment
     * @param  mixed $id comment id
     * @return boolean
     */
    public function remove_comment($id)
    {
        $comment = $this->get_comment($id);
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'renewal_comments');
        if ($this->db->affected_rows() > 0) {
            log_activity('Proposal Comment Removed [ProposalID:' . $comment->proposalid . ', Comment Content: ' . $comment->content . ']');

            return true;
        }

        return false;
    }

    /**
     * Copy proposal
     * @param  mixed $id proposal id
     * @return mixed
     */
    public function copy($id)
    {
        $this->copy      = true;
        $proposal        = $this->get($id, [], true);
        $not_copy_fields = [
            'addedfrom',
            'id',
            'datecreated',
            'hash',
            'status',
            'invoice_id',
            'estimate_id',
            'is_expiry_notified',
            'date_converted',
            'signature',
            'acceptance_firstname',
            'acceptance_lastname',
            'acceptance_email',
            'acceptance_date',
            'acceptance_ip',
        ];
        $fields      = $this->db->list_fields(db_prefix() . 'renewals');
        $insert_data = [];
        foreach ($fields as $field) {
            if (!in_array($field, $not_copy_fields)) {
                $insert_data[$field] = $proposal->$field;
            }
        }

        $insert_data['addedfrom']   = get_staff_user_id();
        $insert_data['datecreated'] = date('Y-m-d H:i:s');
        $insert_data['date']        = _d(date('Y-m-d'));
        $insert_data['status']      = 6;
        $insert_data['hash']        = app_generate_hash();

        // in case open till is expired set new 7 days starting from current date
        if ($insert_data['open_till'] && get_option('proposal_due_after') != 0) {
            $insert_data['open_till'] = _d(date('Y-m-d', strtotime('+' . get_option('proposal_due_after') . ' DAY', strtotime(date('Y-m-d')))));
        }

        $insert_data['newitems'] = [];
        $custom_fields_items     = get_custom_fields('items');
        $key                     = 1;
        foreach ($proposal->items as $item) {
            $insert_data['newitems'][$key]['description']      = $item['description'];
            $insert_data['newitems'][$key]['long_description'] = clear_textarea_breaks($item['long_description']);
            $insert_data['newitems'][$key]['qty']              = $item['qty'];
            $insert_data['newitems'][$key]['unit']             = $item['unit'];
            $insert_data['newitems'][$key]['taxname']          = [];
            $taxes                                             = get_proposal_item_taxes($item['id']);
            foreach ($taxes as $tax) {
                // tax name is in format TAX1|10.00
                array_push($insert_data['newitems'][$key]['taxname'], $tax['taxname']);
            }
            $insert_data['newitems'][$key]['rate']  = $item['rate'];
            $insert_data['newitems'][$key]['order'] = $item['item_order'];
            foreach ($custom_fields_items as $cf) {
                $insert_data['newitems'][$key]['custom_fields']['items'][$cf['id']] = get_custom_field_value($item['id'], $cf['id'], 'items', false);

                if (!defined('COPY_CUSTOM_FIELDS_LIKE_HANDLE_POST')) {
                    define('COPY_CUSTOM_FIELDS_LIKE_HANDLE_POST', true);
                }
            }
            $key++;
        }

        $id = $this->add($insert_data);

        if ($id) {
            $custom_fields = get_custom_fields('proposal');
            foreach ($custom_fields as $field) {
                $value = get_custom_field_value($proposal->id, $field['id'], 'proposal', false);
                if ($value == '') {
                    continue;
                }
                $this->db->insert(db_prefix() . 'customfieldsvalues', [
                    'relid'   => $id,
                    'fieldid' => $field['id'],
                    'fieldto' => 'proposal',
                    'value'   => $value,
                ]);
            }

            $tags = get_tags_in($proposal->id, 'proposal');
            handle_tags_save($tags, $id, 'proposal');

            log_activity('Copied Proposal ' . format_proposal_number($proposal->id));

            return $id;
        }

        return false;
    }

    /**
     * Take proposal action (change status) manually
     * @param  mixed $status status id
     * @param  mixed  $id     proposal id
     * @param  boolean $client is request coming from client side or not
     * @return boolean
     */
    public function mark_action_status($status, $id, $client = false)
    {
        $original_proposal = $this->get($id);
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'renewals', [
            'status' => $status,
        ]);

        if ($this->db->affected_rows() > 0) {
            // Client take action
            if ($client == true) {
                $revert = false;
                // Declined
                if ($status == 2) {
                    $message = 'not_proposal_proposal_declined';
                } elseif ($status == 3) {
                    $message = 'not_proposal_proposal_accepted';
                // Accepted
                } else {
                    $revert = true;
                }
                // This is protection that only 3 and 4 statuses can be taken as action from the client side
                if ($revert == true) {
                    $this->db->where('id', $id);
                    $this->db->update(db_prefix() . 'renewals', [
                        'status' => $original_proposal->status,
                    ]);

                    return false;
                }

                // Get creator and assigned;
                $this->db->where('staffid', $original_proposal->addedfrom);
                $this->db->or_where('staffid', $original_proposal->assigned);
                $staff_proposal = $this->db->get(db_prefix() . 'staff')->result_array();
                $notifiedUsers  = [];
                foreach ($staff_proposal as $member) {
                    $notified = add_notification([
                            'fromcompany'     => true,
                            'touserid'        => $member['staffid'],
                            'description'     => $message,
                            'link'            => 'renewals/list_renewals/' . $id,
                            'additional_data' => serialize([
                                format_proposal_number($id),
                            ]),
                        ]);
                    if ($notified) {
                        array_push($notifiedUsers, $member['staffid']);
                    }
                }

                pusher_trigger_notification($notifiedUsers);

                // Send thank you to the customer email template
                if ($status == 3) {
                    foreach ($staff_proposal as $member) {
                        send_mail_template('proposal_accepted_to_staff', $original_proposal, $member['email']);
                    }

                    send_mail_template('proposal_accepted_to_customer', $original_proposal);

                    hooks()->do_action('proposal_accepted', $id);
                } else {

                    // Client declined send template to admin
                    foreach ($staff_proposal as $member) {
                        send_mail_template('proposal_declined_to_staff', $original_proposal, $member['email']);
                    }

                    hooks()->do_action('proposal_declined', $id);
                }
            } else {
                // in case admin mark as open the the open till date is smaller then current date set open till date 7 days more
                if ((date('Y-m-d', strtotime($original_proposal->open_till)) < date('Y-m-d')) && $status == 1) {
                    $open_till = date('Y-m-d', strtotime('+7 DAY', strtotime(date('Y-m-d'))));
                    $this->db->where('id', $id);
                    $this->db->update(db_prefix() . 'renewals', [
                        'open_till' => $open_till,
                    ]);
                }
            }

            log_activity('Proposal Status Changes [ProposalID:' . $id . ', Status:' . format_proposal_status($status, '', false) . ',Client Action: ' . (int) $client . ']');

            return true;
        }

        return false;
    }

    /**
     * Delete proposal
     * @param  mixed $id proposal id
     * @return boolean
     */
    public function delete($id)
    {
        $this->clear_signature($id);
        $proposal = $this->get($id);

        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'renewals');
        if ($this->db->affected_rows() > 0) {
            if (!is_null($proposal->short_link)) {
                app_archive_short_link($proposal->short_link);
            }

            delete_tracked_emails($id, 'proposal');

            $this->db->where('proposalid', $id);
            $this->db->delete(db_prefix() . 'proposal_comments');
            // Get related tasks
            $this->db->where('rel_type', 'proposal');
            $this->db->where('rel_id', $id);

            $tasks = $this->db->get(db_prefix() . 'tasks')->result_array();
            foreach ($tasks as $task) {
                $this->tasks_model->delete_task($task['id']);
            }

            $attachments = $this->get_attachments($id);
            foreach ($attachments as $attachment) {
                $this->delete_attachment($attachment['id']);
            }

            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'proposal');
            $this->db->delete(db_prefix() . 'notes');

            $this->db->where('relid IN (SELECT id from ' . db_prefix() . 'itemable WHERE rel_type="proposal" AND rel_id="' . $this->db->escape_str($id) . '")');
            $this->db->where('fieldto', 'items');
            $this->db->delete(db_prefix() . 'customfieldsvalues');

            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'proposal');
            $this->db->delete(db_prefix() . 'itemable');


            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'proposal');
            $this->db->delete(db_prefix() . 'item_tax');

            $this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'proposal');
            $this->db->delete(db_prefix() . 'taggables');

            // Delete the custom field values
            $this->db->where('relid', $id);
            $this->db->where('fieldto', 'proposal');
            $this->db->delete(db_prefix() . 'customfieldsvalues');

            $this->db->where('rel_type', 'proposal');
            $this->db->where('rel_id', $id);
            $this->db->delete(db_prefix() . 'reminders');

            $this->db->where('rel_type', 'proposal');
            $this->db->where('rel_id', $id);
            $this->db->delete(db_prefix() . 'views_tracking');

            log_activity('Proposal Deleted [ProposalID:' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Get relation proposal data. Ex lead or customer will return the necesary db fields
     * @param  mixed $rel_id
     * @param  string $rel_type customer/lead
     * @return object
     */
    public function get_relation_data_values($rel_id, $rel_type)
    {
        $data = new StdClass();
        if ($rel_type == 'customer') {
            $this->db->where('userid', $rel_id);
            $_data = $this->db->get(db_prefix() . 'clients')->row();

            $primary_contact_id = get_primary_contact_user_id($rel_id);

            if ($primary_contact_id) {
                $contact     = $this->clients_model->get_contact($primary_contact_id);
                $data->email = $contact->email;
            }

            $data->phone            = $_data->phonenumber;
            $data->is_using_company = false;
            if (isset($contact)) {
                $data->to = $contact->firstname . ' ' . $contact->lastname;
            } else {
                if (!empty($_data->company)) {
                    $data->to               = $_data->company;
                    $data->is_using_company = true;
                }
            }
            $data->company = $_data->company;
            $data->address = clear_textarea_breaks($_data->address);
            $data->zip     = $_data->zip;
            $data->country = $_data->country;
            $data->state   = $_data->state;
            $data->city    = $_data->city;

            $default_currency = $this->clients_model->get_customer_default_currency($rel_id);
            if ($default_currency != 0) {
                $data->currency = $default_currency;
            }
        } elseif ($rel_type = 'lead') {
            $this->db->where('id', $rel_id);
            $_data       = $this->db->get(db_prefix() . 'leads')->row();
            $data->phone = $_data->phonenumber;

            $data->is_using_company = false;

            if (empty($_data->company)) {
                $data->to = $_data->name;
            } else {
                $data->to               = $_data->company;
                $data->is_using_company = true;
            }

            $data->company = $_data->company;
            $data->address = $_data->address;
            $data->email   = $_data->email;
            $data->zip     = $_data->zip;
            $data->country = $_data->country;
            $data->state   = $_data->state;
            $data->city    = $_data->city;
        }

        return $data;
    }

    /**
     * Sent proposal to email
     * @param  mixed  $id        proposalid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach proposal pdf or not
     * @return boolean
     */
    public function send_expiry_reminder($id)
    {
        $proposal = $this->get($id);

        // For all cases update this to prevent sending multiple reminders eq on fail
        $this->db->where('id', $proposal->id);
        $this->db->update(db_prefix() . 'renewals', [
            'is_expiry_notified' => 1,
        ]);

        $template     = mail_template('proposal_expiration_reminder', $proposal);
        $merge_fields = $template->get_merge_fields();

        $template->send();

        if (can_send_sms_based_on_creation_date($proposal->datecreated)) {
            $sms_sent = $this->app_sms->trigger(SMS_TRIGGER_PROPOSAL_EXP_REMINDER, $proposal->phone, $merge_fields);
        }

        return true;
    }

    public function send_proposal_to_email($id, $attachpdf = true, $cc = '')
    {
        // Proposal status is draft update to sent
        if (total_rows(db_prefix() . 'renewals', ['id' => $id, 'status' => 6]) > 0) {
            $this->db->where('id', $id);
            $this->db->update(db_prefix() . 'renewals', ['status' => 4]);
        }

        $proposal = $this->get($id);

        $sent = send_mail_template('proposal_send_to_customer', $proposal, $attachpdf, $cc);

        if ($sent) {

            // Set to status sent
            $this->db->where('id', $id);
            $this->db->update(db_prefix() . 'renewals', [
                'status' => 4,
            ]);

            hooks()->do_action('proposal_sent', $id);

            return true;
        }

        return false;
    }
}
